/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.table.VWSortedComboBoxModel;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionItem;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWWSOperationWrapper;
import filenet.ws.api.WSOperation;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class VWPartnerLinkDescriptionPanel
extends JPanel
implements IVWDescriptionPanel,
ActionListener {
    private JTextField m_partnerLinkTextField = null;
    private JComboBox m_operationComboBox = null;
    private JTextArea m_headerTextArea = null;
    private VWPartnerLinkDefinition m_partnerLinkDef = null;
    private IVWPropertyData m_propertyData = null;

    public VWPartnerLinkDescriptionPanel(IVWPropertyData propertyData) {
        this.m_propertyData = propertyData;
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 2, 0, 0);
        VWToolbarBorder partnerLinkBorder = new VWToolbarBorder(VWResource.s_partnerLink);
        this.add((Component)partnerLinkBorder, gbCons);
        JPanel partnerLinkPanel = partnerLinkBorder.getClientPanel();
        partnerLinkPanel.setLayout(new GridLayout());
        this.m_partnerLinkTextField = new JTextField();
        this.m_partnerLinkTextField.setEditable(false);
        partnerLinkPanel.add(this.m_partnerLinkTextField);
        ++gbCons.gridy;
        VWToolbarBorder operationBorder = new VWToolbarBorder(VWResource.s_operation);
        this.add((Component)operationBorder, gbCons);
        JPanel operationPanel = operationBorder.getClientPanel();
        operationPanel.setLayout(new GridLayout());
        this.m_operationComboBox = new JComboBox(new VWSortedComboBoxModel());
        this.m_operationComboBox.setEnabled(false);
        this.m_operationComboBox.addActionListener(this);
        operationPanel.add(this.m_operationComboBox);
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weighty = 1.0;
        VWToolbarBorder headerBorder = new VWToolbarBorder(VWResource.s_headerInformation);
        this.add((Component)headerBorder, gbCons);
        JPanel headerPanel = headerBorder.getClientPanel();
        headerPanel.setLayout(new GridLayout());
        this.m_headerTextArea = new JTextArea();
        this.m_headerTextArea.setEditable(false);
        headerPanel.add(new JScrollPane(this.m_headerTextArea));
    }

    public void clean() {
        this.m_partnerLinkTextField.setText("");
        this.initOperationComboBox();
        this.m_headerTextArea.setText("");
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_operationComboBox) {
            this.performOperationAction();
        }
    }

    public void setExpressionItem(VWExpressionItem item) {
        Object expressionItem;
        this.m_partnerLinkDef = null;
        if (item != null && (expressionItem = item.getExpressionItem()) instanceof VWPartnerLinkDefinition) {
            this.m_partnerLinkDef = (VWPartnerLinkDefinition)expressionItem;
        }
        this.reinitialize();
    }

    public String getExpressionItem() {
        String expressionItem = null;
        try {
            expressionItem = this.m_headerTextArea.getText();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return expressionItem;
    }

    private void reinitialize() {
        try {
            if (this.m_partnerLinkDef != null) {
                this.m_partnerLinkTextField.setText(this.m_partnerLinkDef.getName());
                this.initOperationComboBox();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performOperationAction() {
        VWWebServiceUtils webServiceUtils;
        String header = null;
        if (this.m_partnerLinkDef != null && (webServiceUtils = this.m_propertyData.getWebServiceUtils()) != null) {
            VWWSOperationWrapper operationWrapper = (VWWSOperationWrapper)this.m_operationComboBox.getSelectedItem();
            header = webServiceUtils.getHeaderInformation(this.m_partnerLinkDef, operationWrapper.getWSOperation());
        }
        this.m_headerTextArea.setText(header);
    }

    private void initOperationComboBox() {
        this.m_operationComboBox.removeActionListener(this);
        VWSortedComboBoxModel model = (VWSortedComboBoxModel)this.m_operationComboBox.getModel();
        model.removeAllElements();
        try {
            VWWebServiceUtils webServiceUtils;
            if (this.m_partnerLinkDef != null && (webServiceUtils = this.m_propertyData.getWebServiceUtils()) != null) {
                WSOperation[] operations = webServiceUtils.getOperationsFromPartnerLink(this.m_partnerLinkDef, false);
                if (operations != null && operations.length > 0) {
                    int i;
                    this.m_operationComboBox.setEnabled(true);
                    Object[] operationWrappers = new VWWSOperationWrapper[operations.length];
                    for (i = 0; i < operations.length; ++i) {
                        operationWrappers[i] = new VWWSOperationWrapper(operations[i]);
                    }
                    VWQubbleSort.sort(operationWrappers);
                    for (i = 0; i < operationWrappers.length; ++i) {
                        model.addElement(operationWrappers[i]);
                    }
                } else {
                    this.m_operationComboBox.setEnabled(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_operationComboBox.addActionListener(this);
        if (model.getSize() > 0) {
            this.m_operationComboBox.setSelectedIndex(0);
        }
    }
}

